
package edu.unl.consystlab.sudokuSolver;

import java.util.Collection;
import java.util.Iterator;
import edu.unl.consystlab.sudokuConstructor.consistencyAlgorithms.*;

/**
 *
 * @author jasongaare
 */
public class checkConsistencyNeeded {

    private constraintProblem myProblem;
    private String[] numbers;
    private int unassignedVars;
    private consistencyAlgorithm myAlgorithm;

    public checkConsistencyNeeded(String puzzle){

        numbers = puzzle.split("");

    }
    
    public String checkConsistency() {


        if (numbers != null) {

            myProblem = loadProblemFromArray(numbers);

            unassignedVars = 0;

            //iterate through the puzzle to find number of unassigned variables
            Iterator i = ((Collection)myProblem.getAllVariables()).iterator();
            while(i.hasNext())
            {
                problemVariable currentVariable = (problemVariable)i.next();
                if(!currentVariable.isAssigned())
                {
                    unassignedVars++;
                }
            }

            //run AC and count number of variables assigned
            myAlgorithm = new arcConsistency(myProblem);
            myAlgorithm.runAlgorithm();
            int variablesReduced = myAlgorithm.getVariableReductions().size();

            //if all variables are assigned
            if(variablesReduced == (8*unassignedVars))
            {
                return "AC";

            }

            else
            {
                //run GAC
                myAlgorithm = new nonBinaryMAC(myProblem);
                myAlgorithm.runAlgorithm();
                variablesReduced += myAlgorithm.getVariableReductions().size();

                if(variablesReduced== (8*unassignedVars))
                {
                    return "GAC";
                }
                else
                {
                    variablesReduced = 0;

                    //clear puzzle and run AC, then check SAC
                    myProblem = loadProblemFromArray(numbers);
                    myAlgorithm = new arcConsistency(myProblem);
                    myAlgorithm.runAlgorithm();
                    variablesReduced = myAlgorithm.getVariableReductions().size();

                    //check SAC
                    myAlgorithm = new shavingMAC(myProblem);
                    myAlgorithm.runAlgorithm();
                    variablesReduced += myAlgorithm.getVariableReductions().size();
                    

                    if(variablesReduced== (8*unassignedVars))
                    {
                        return "SAC";
                    }
                    //alternate between GAC and SAC, to see if together they can
                    //solve the puzzle
                    else
                    {
                        int curVariablesReduced = 0;
                        boolean alternate = true;

                        do{
                            if(alternate)
                            {
                                myAlgorithm = new nonBinaryMAC(myProblem);
                                myAlgorithm.runAlgorithm();
                                curVariablesReduced = myAlgorithm.getVariableReductions().size();
                            }
                            else
                            {
                               myAlgorithm = new shavingMAC(myProblem);
                               myAlgorithm.runAlgorithm();
                               curVariablesReduced = myAlgorithm.getVariableReductions().size();
                            }

                            variablesReduced += curVariablesReduced;
                            if(variablesReduced== (8*unassignedVars))
                            {
                                return "SAC + GAC";
                            }

                            alternate = !alternate;

                        }while(curVariablesReduced != 0);

                        //run SGAC
                        myAlgorithm = new shavingGAC(myProblem);
                        myAlgorithm.runAlgorithm();
                        variablesReduced += myAlgorithm.getVariableReductions().size();

                        if(variablesReduced == (8*unassignedVars))
                        {
                            return "SGAC";
                        }
                    }

                }
            }

        }

        return "Unsolved";
     }


    private constraintProblem loadProblemFromArray(String [] numArray)
	{
		parserArray myparser = new parserArray();
		myparser.parseArray(numArray);
		System.out.println("Load constraint from array");
		return myparser.getProblem();
	}

}
